<?php
require_once 'config/database.php';

class Verification {
    private $db;
    
    public function __construct() {
        $database = new Database();
        $this->db = $database->getConnection();
    }
    
    public function createVerification($userId, $verificationId, $checkToken = null) {
        $stmt = $this->db->prepare("
            INSERT INTO verifications (user_id, verification_id, check_token) 
            VALUES (?, ?, ?)
        ");
        
        return $stmt->execute([$userId, $verificationId, $checkToken]);
    }
    
    public function updateStatus($verificationId, $status, $message = null) {
        $stmt = $this->db->prepare("
            UPDATE verifications 
            SET status = ?, message = ?, updated_at = NOW()
            WHERE verification_id = ?
        ");
        
        return $stmt->execute([$status, $message, $verificationId]);
    }
    
    public function getVerification($verificationId) {
        $stmt = $this->db->prepare("
            SELECT v.*, u.telegram_id 
            FROM verifications v 
            JOIN users u ON v.user_id = u.id 
            WHERE v.verification_id = ?
        ");
        $stmt->execute([$verificationId]);
        return $stmt->fetch();
    }
    
    public function getUserVerifications($userId, $limit = 10) {
        // Validate and sanitize limit parameter
        $limit = (int)$limit;
        if ($limit <= 0) $limit = 10;
        if ($limit > 100) $limit = 100; // Prevent excessive queries
        
        $stmt = $this->db->prepare("
            SELECT * FROM verifications 
            WHERE user_id = ? 
            ORDER BY created_at DESC 
            LIMIT $limit
        ");
        $stmt->execute([$userId]);
        return $stmt->fetchAll();
    }
    
    public function createBatchVerification($userId, $batchId, $totalVerifications) {
        $stmt = $this->db->prepare("
            INSERT INTO batch_verifications (user_id, batch_id, total_verifications) 
            VALUES (?, ?, ?)
        ");
        
        return $stmt->execute([$userId, $batchId, $totalVerifications]);
    }
    
    public function updateBatchStatus($batchId, $status, $completedVerifications = null) {
        $sql = "UPDATE batch_verifications SET status = ?, updated_at = NOW()";
        $params = [$status];
        
        if ($completedVerifications !== null) {
            $sql .= ", completed_verifications = ?";
            $params[] = $completedVerifications;
        }
        
        $sql .= " WHERE batch_id = ?";
        $params[] = $batchId;
        
        $stmt = $this->db->prepare($sql);
        return $stmt->execute($params);
    }
    
    public function getBatchVerification($batchId) {
        $stmt = $this->db->prepare("
            SELECT bv.*, u.telegram_id 
            FROM batch_verifications bv 
            JOIN users u ON bv.user_id = u.id 
            WHERE bv.batch_id = ?
        ");
        $stmt->execute([$batchId]);
        return $stmt->fetch();
    }
}
?>