<?php
require_once 'config/database.php';

class User {
    private $db;
    
    public function __construct() {
        $database = new Database();
        $this->db = $database->getConnection();
    }
    
    public function findOrCreate($telegramId, $userData = []) {
        try {
            // Cek apakah user sudah ada
            $stmt = $this->db->prepare("SELECT * FROM users WHERE telegram_id = ?");
            $stmt->execute([$telegramId]);
            $user = $stmt->fetch();
            
            if ($user) {
                // Update data user jika ada perubahan
                $this->updateUser($user['id'], $userData);
                return $user;
            }
            
            // Buat user baru
            $stmt = $this->db->prepare("
                INSERT INTO users (telegram_id, username, first_name, last_name) 
                VALUES (?, ?, ?, ?)
            ");
            
            $stmt->execute([
                $telegramId,
                $userData['username'] ?? null,
                $userData['first_name'] ?? null,
                $userData['last_name'] ?? null
            ]);
            
            return $this->findOrCreate($telegramId);
        } catch (Exception $e) {
            // Log error and throw with more context
            error_log("User findOrCreate error: " . $e->getMessage());
            throw new Exception("Database error in User::findOrCreate: " . $e->getMessage());
        }
    }
    
    private function updateUser($userId, $userData) {
        try {
            $stmt = $this->db->prepare("
                UPDATE users 
                SET username = ?, first_name = ?, last_name = ?, updated_at = NOW()
                WHERE id = ?
            ");
            
            $stmt->execute([
                $userData['username'] ?? null,
                $userData['first_name'] ?? null,
                $userData['last_name'] ?? null,
                $userId
            ]);
        } catch (Exception $e) {
            error_log("User updateUser error: " . $e->getMessage());
            throw new Exception("Database error in User::updateUser: " . $e->getMessage());
        }
    }
}
?>