<?php
// Error handler untuk logging yang kompatibel dengan Windows

function logError($message, $file = 'error.log') {
    $logDir = __DIR__ . '/../logs/';
    
    // Buat folder logs jika belum ada
    if (!is_dir($logDir)) {
        @mkdir($logDir, 0755, true);
    }
    
    $logFile = $logDir . $file;
    $timestamp = date('Y-m-d H:i:s');
    $logMessage = "[$timestamp] $message" . PHP_EOL;
    
    // Try to write to log file
    @file_put_contents($logFile, $logMessage, FILE_APPEND | LOCK_EX);
}

function logWebhook($data, $file = 'webhook.log') {
    $message = "Webhook received: " . json_encode($data);
    logError($message, $file);
}

function logBotActivity($message, $file = 'bot.log') {
    logError($message, $file);
}

// Set custom error handler
set_error_handler(function($severity, $message, $file, $line) {
    $errorMessage = "PHP Error [$severity]: $message in $file on line $line";
    logError($errorMessage);
    
    // Return false to continue with normal error handling
    return false;
});

// Set exception handler
set_exception_handler(function($exception) {
    $errorMessage = "Uncaught Exception: " . $exception->getMessage() . 
                   " in " . $exception->getFile() . 
                   " on line " . $exception->getLine();
    logError($errorMessage);
});

// Register shutdown function untuk fatal errors
register_shutdown_function(function() {
    $error = error_get_last();
    if ($error && in_array($error['type'], [E_ERROR, E_CORE_ERROR, E_COMPILE_ERROR, E_PARSE])) {
        $errorMessage = "Fatal Error: " . $error['message'] . 
                       " in " . $error['file'] . 
                       " on line " . $error['line'];
        logError($errorMessage);
    }
});
?>