<?php
// Telegram Bot Configuration
define('BOT_TOKEN', '8540135184:AAHXptFtW03wwy5wNNYyoGavI3A5_Tb0Ywc'); // Ganti dengan token bot Anda
define('API_URL', 'https://api.telegram.org/bot' . BOT_TOKEN . '/');

class TelegramBot {
    private $token;
    private $apiUrl;
    
    public function __construct() {
        $this->token = BOT_TOKEN;
        $this->apiUrl = API_URL;
    }
    
    public function sendMessage($chatId, $text, $replyMarkup = null) {
        $data = [
            'chat_id' => $chatId,
            'text' => $text,
            'parse_mode' => 'HTML'
        ];
        
        if ($replyMarkup) {
            $data['reply_markup'] = json_encode($replyMarkup);
        }
        
        return $this->makeRequest('sendMessage', $data);
    }
    
    public function editMessage($chatId, $messageId, $text, $replyMarkup = null) {
        $data = [
            'chat_id' => $chatId,
            'message_id' => $messageId,
            'text' => $text,
            'parse_mode' => 'HTML'
        ];
        
        if ($replyMarkup) {
            $data['reply_markup'] = json_encode($replyMarkup);
        }
        
        return $this->makeRequest('editMessageText', $data);
    }
    
    public function makeRequest($method, $data) {
        $url = $this->apiUrl . $method;
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        
        $result = curl_exec($ch);
        curl_close($ch);
        
        return json_decode($result, true);
    }
    
    public function getBotInfo() {
        return $this->makeRequest('getMe', []);
    }
    
    public function getWebhookInfo() {
        return $this->makeRequest('getWebhookInfo', []);
    }
    
    public function setWebhook($url, $allowedUpdates = ['message', 'callback_query']) {
        return $this->makeRequest('setWebhook', [
            'url' => $url,
            'allowed_updates' => $allowedUpdates
        ]);
    }
    
    public function deleteWebhook() {
        return $this->makeRequest('deleteWebhook', []);
    }
}
?>