<?php
// cPanel Database configuration template
// Copy this file to database.php and update with your actual cPanel credentials

// IMPORTANT: Get these values from your cPanel → MySQL Databases
define('DB_HOST', 'localhost');                    // Usually 'localhost' for cPanel
define('DB_NAME', 'jajargenjang_bot');             // Your actual database name from cPanel
define('DB_USER', 'jajargenjang_botuser');         // Your actual database user from cPanel  
define('DB_PASS', 'your_actual_database_password'); // Your actual database password

class Database {
    private $connection;
    
    public function __construct() {
        try {
            $this->connection = new PDO(
                "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8",
                DB_USER,
                DB_PASS,
                [
                    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                    PDO::ATTR_EMULATE_PREPARES => false
                ]
            );
        } catch (PDOException $e) {
            // Log error instead of showing it publicly
            error_log("Database connection failed: " . $e->getMessage());
            die("Database connection failed. Please check your configuration.");
        }
    }
    
    public function getConnection() {
        return $this->connection;
    }
}
?>

<!-- 
INSTRUCTIONS FOR cPanel SETUP:

1. LOGIN TO cPanel
2. Go to "MySQL Databases" 
3. Find your database information:
   - Database name (usually: username_dbname)
   - Database user (usually: username_username)
   - Database password (you set this when creating the user)

4. UPDATE THE VALUES ABOVE:
   - DB_NAME: Replace 'jajargenjang_bot' with your actual database name
   - DB_USER: Replace 'jajargenjang_botuser' with your actual database user
   - DB_PASS: Replace 'your_actual_database_password' with your actual password

5. SAVE this file as 'database.php' (remove '_cpanel_template' from filename)

6. TEST the connection using admin/fix_cpanel_database.php

COMMON cPanel DATABASE PATTERNS:
- Database: jajargenjang_bot, jajargenjang_telegram, jajargenjang_db
- User: jajargenjang_bot, jajargenjang_user, jajargenjang_admin
- Host: Always 'localhost' for cPanel shared hosting
-->