<?php
// Admin configuration untuk bot Telegram

// Daftar Admin Telegram IDs (ganti dengan ID Telegram admin yang sebenarnya)
define('ADMIN_TELEGRAM_IDS', [
    123456789,  // Ganti dengan Telegram ID admin 1
    987654321,  // Ganti dengan Telegram ID admin 2 (opsional)
    // Tambahkan ID admin lain jika diperlukan
]);

// Super Admin (pemilik bot utama)
define('SUPER_ADMIN_ID', 123456789); // Ganti dengan ID Telegram Anda

class BotAdminAuth {
    
    public static function isAdmin($telegramId) {
        return in_array($telegramId, ADMIN_TELEGRAM_IDS);
    }
    
    public static function isSuperAdmin($telegramId) {
        return $telegramId == SUPER_ADMIN_ID;
    }
    
    public static function requireAdmin($telegramId) {
        return self::isAdmin($telegramId);
    }
    
    public static function getAdminLevel($telegramId) {
        if (self::isSuperAdmin($telegramId)) {
            return 'super_admin';
        } elseif (self::isAdmin($telegramId)) {
            return 'admin';
        } else {
            return 'user';
        }
    }
    
    public static function canManageTokens($telegramId) {
        // Hanya admin yang bisa manage token
        return self::isAdmin($telegramId);
    }
    
    public static function canManageUsers($telegramId) {
        // Hanya super admin yang bisa manage users
        return self::isSuperAdmin($telegramId);
    }
    
    public static function canViewAllVerifications($telegramId) {
        // Admin bisa lihat semua verifikasi
        return self::isAdmin($telegramId);
    }
}

// Helper function untuk mendapatkan Telegram ID
function getTelegramId() {
    // Untuk mendapatkan ID Telegram Anda:
    // 1. Kirim pesan ke bot @userinfobot
    // 2. Atau kirim pesan ke bot @get_id_bot
    // 3. Atau gunakan bot ini dan lihat di logs
    
    return null;
}
?>