<?php
// Update API base URL to correct value
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h1>Update API Base URL</h1>";
echo "<hr>";

try {
    require_once '../config/database.php';
    require_once '../models/GlobalSettings.php';
    
    $settings = new GlobalSettings();
    
    echo "<h3>Current Settings</h3>";
    $currentUrl = $settings->getApiBaseUrl();
    echo "Current API Base URL: " . htmlspecialchars($currentUrl) . "<br>";
    
    echo "<h3>Updating API Base URL</h3>";
    $newUrl = 'https://neigui.1key.me';
    
    $result = $settings->setApiBaseUrl($newUrl);
    
    if ($result) {
        echo "✅ API Base URL updated successfully!<br>";
        echo "New URL: " . htmlspecialchars($newUrl) . "<br>";
        
        // Verify update
        $verifyUrl = $settings->getApiBaseUrl();
        echo "Verified URL: " . htmlspecialchars($verifyUrl) . "<br>";
        
        if ($verifyUrl === $newUrl) {
            echo "✅ Update confirmed!<br>";
        } else {
            echo "❌ Update verification failed<br>";
        }
    } else {
        echo "❌ Failed to update API Base URL<br>";
    }
    
    echo "<h3>✅ Update Complete</h3>";
    echo "<p>Bot will now use the correct API endpoint: <code>$newUrl</code></p>";
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "<br>";
}

echo "<br><p><a href='test_api.php'>Test API Connection</a> | <a href='settings.php'>Admin Settings</a></p>";
?>