<?php
// Test API connection and debug
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h1>Test API Connection</h1>";
echo "<hr>";

try {
    require_once '../config/database.php';
    require_once '../models/GlobalSettings.php';
    require_once '../services/VerificationService.php';
    
    echo "<h3>1. Check Global Settings</h3>";
    $settings = new GlobalSettings();
    
    $apiBaseUrl = $settings->getApiBaseUrl();
    echo "API Base URL: " . htmlspecialchars($apiBaseUrl) . "<br>";
    
    $tokens = $settings->getTokens();
    echo "HCaptcha Token: " . (strlen($tokens['hcaptcha_token']) > 0 ? '✅ Set (' . strlen($tokens['hcaptcha_token']) . ' chars)' : '❌ Not set') . "<br>";
    echo "Turnstile Token: " . (strlen($tokens['turnstile_token']) > 0 ? '✅ Set (' . strlen($tokens['turnstile_token']) . ' chars)' : '❌ Not set') . "<br>";
    
    echo "<h3>2. Test API Base URL</h3>";
    
    // Test if API URL is reachable
    $testUrl = $apiBaseUrl . '/api/batch';
    echo "Testing URL: " . htmlspecialchars($testUrl) . "<br>";
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $testUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    curl_setopt($ch, CURLOPT_NOBODY, true); // HEAD request
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'HEAD');
    
    $result = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $error = curl_error($ch);
    curl_close($ch);
    
    if ($error) {
        echo "❌ CURL Error: " . htmlspecialchars($error) . "<br>";
    } else {
        echo "HTTP Response Code: $httpCode<br>";
        if ($httpCode >= 200 && $httpCode < 400) {
            echo "✅ API endpoint is reachable<br>";
        } else {
            echo "❌ API endpoint returned error code<br>";
        }
    }
    
    echo "<h3>3. Test VerificationService</h3>";
    
    $verificationService = new VerificationService();
    echo "✅ VerificationService instantiated<br>";
    
    echo "<h3>4. Test API Request (if tokens available)</h3>";
    
    if ($tokens['hcaptcha_token']) {
        echo "Testing with sample verification ID...<br>";
        
        // Test with sample data
        $testVerificationIds = ['test_verification_id'];
        
        echo "Request data:<br>";
        echo "- hCaptchaToken: " . substr($tokens['hcaptcha_token'], 0, 20) . "...<br>";
        echo "- verificationIds: " . json_encode($testVerificationIds) . "<br>";
        echo "- API URL: " . htmlspecialchars($apiBaseUrl . '/api/batch') . "<br>";
        
        // Note: We won't actually make the request to avoid using quota
        echo "<br>⚠️ <strong>Note:</strong> Actual API request not made to avoid using verification quota.<br>";
        echo "To test real API, use a valid verification ID from SheerID.<br>";
        
    } else {
        echo "❌ Cannot test API - HCaptcha token not set<br>";
        echo "Please set tokens in admin panel first.<br>";
    }
    
    echo "<h3>5. Recommendations</h3>";
    
    if ($apiBaseUrl === 'https://your-api-domain.com') {
        echo "❌ <strong>API Base URL not configured!</strong><br>";
        echo "Please update API Base URL in admin settings to: <code>https://neigui.1key.me</code><br><br>";
    }
    
    if (!$tokens['hcaptcha_token']) {
        echo "❌ <strong>HCaptcha token not set!</strong><br>";
        echo "Please set HCaptcha token in admin settings.<br><br>";
    }
    
    echo "✅ <strong>Next steps:</strong><br>";
    echo "1. Set API Base URL to: <code>https://neigui.1key.me</code><br>";
    echo "2. Set valid HCaptcha token in admin settings<br>";
    echo "3. Test with real SheerID verification URL<br>";
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "<br>";
    echo "File: " . $e->getFile() . "<br>";
    echo "Line: " . $e->getLine() . "<br>";
}

echo "<br><p><a href='settings.php'>Admin Settings</a> | <a href='index.php'>Dashboard</a></p>";
?>