            </main>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- Custom JS -->
    <script>
        // Auto-refresh untuk real-time data
        function autoRefresh() {
            if (window.location.pathname.includes('index.php') || window.location.pathname.endsWith('/admin/')) {
                setTimeout(() => {
                    location.reload();
                }, 30000); // Refresh setiap 30 detik
            }
        }
        
        // Konfirmasi delete
        function confirmDelete(message = 'Apakah Anda yakin ingin menghapus item ini?') {
            return confirm(message);
        }
        
        // Format angka
        function formatNumber(num) {
            return num.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
        }
        
        // Copy to clipboard
        function copyToClipboard(text) {
            navigator.clipboard.writeText(text).then(() => {
                showAlert('Berhasil disalin ke clipboard!', 'success');
            });
        }
        
        // Show alert
        function showAlert(message, type = 'info') {
            const alertDiv = document.createElement('div');
            alertDiv.className = `alert alert-${type} alert-dismissible fade show position-fixed`;
            alertDiv.style.cssText = 'top: 20px; right: 20px; z-index: 9999; min-width: 300px;';
            alertDiv.innerHTML = `
                ${message}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            `;
            
            document.body.appendChild(alertDiv);
            
            setTimeout(() => {
                alertDiv.remove();
            }, 5000);
        }
        
        // Initialize tooltips
        document.addEventListener('DOMContentLoaded', function() {
            var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
            var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
                return new bootstrap.Tooltip(tooltipTriggerEl);
            });
            
            // Auto refresh
            autoRefresh();
        });
        
        // AJAX helper
        function ajaxRequest(url, data, callback, method = 'POST') {
            const xhr = new XMLHttpRequest();
            xhr.open(method, url, true);
            xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
            
            xhr.onreadystatechange = function() {
                if (xhr.readyState === 4) {
                    if (xhr.status === 200) {
                        try {
                            const response = JSON.parse(xhr.responseText);
                            callback(response);
                        } catch (e) {
                            callback({success: false, message: 'Invalid response'});
                        }
                    } else {
                        callback({success: false, message: 'Request failed'});
                    }
                }
            };
            
            if (method === 'POST') {
                const formData = new URLSearchParams(data).toString();
                xhr.send(formData);
            } else {
                xhr.send();
            }
        }
        
        // Real-time status updates
        function updateStatus(elementId, status) {
            const element = document.getElementById(elementId);
            if (element) {
                const badges = {
                    'success': '<span class="badge bg-success">Success</span>',
                    'error': '<span class="badge bg-danger">Error</span>',
                    'pending': '<span class="badge bg-warning">Pending</span>',
                    'processing': '<span class="badge bg-info">Processing</span>',
                    'cancelled': '<span class="badge bg-secondary">Cancelled</span>'
                };
                element.innerHTML = badges[status] || status;
            }
        }
        
        // Search functionality
        function searchTable(inputId, tableId) {
            const input = document.getElementById(inputId);
            const table = document.getElementById(tableId);
            
            if (!input || !table) return;
            
            input.addEventListener('keyup', function() {
                const filter = this.value.toLowerCase();
                const rows = table.getElementsByTagName('tr');
                
                for (let i = 1; i < rows.length; i++) {
                    const row = rows[i];
                    const cells = row.getElementsByTagName('td');
                    let found = false;
                    
                    for (let j = 0; j < cells.length; j++) {
                        if (cells[j].textContent.toLowerCase().includes(filter)) {
                            found = true;
                            break;
                        }
                    }
                    
                    row.style.display = found ? '' : 'none';
                }
            });
        }
    </script>
    
    <?php if (isset($customJS)): ?>
        <script><?php echo $customJS; ?></script>
    <?php endif; ?>
</body>
</html>