<?php
// Admin panel configuration
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Admin credentials (ganti dengan kredensial yang aman)
define('ADMIN_USERNAME', 'admin');
define('ADMIN_PASSWORD', 'admin123'); // Ganti dengan password yang kuat

// Admin settings
define('ADMIN_SESSION_TIMEOUT', 3600); // 1 hour
define('ITEMS_PER_PAGE', 20);

class AdminAuth {
    public static function login($username, $password) {
        if ($username === ADMIN_USERNAME && $password === ADMIN_PASSWORD) {
            $_SESSION['admin_logged_in'] = true;
            $_SESSION['admin_login_time'] = time();
            return true;
        }
        return false;
    }
    
    public static function logout() {
        session_destroy();
    }
    
    public static function isLoggedIn() {
        if (!isset($_SESSION['admin_logged_in']) || !$_SESSION['admin_logged_in']) {
            return false;
        }
        
        // Check session timeout
        if (isset($_SESSION['admin_login_time'])) {
            if (time() - $_SESSION['admin_login_time'] > ADMIN_SESSION_TIMEOUT) {
                self::logout();
                return false;
            }
        }
        
        return true;
    }
    
    public static function requireLogin() {
        if (!self::isLoggedIn()) {
            header('Location: login.php');
            exit;
        }
    }
}

// Helper functions
function formatDate($date) {
    return date('d/m/Y H:i:s', strtotime($date));
}

function formatNumber($number) {
    return number_format($number);
}

function getStatusBadge($status) {
    $badges = [
        'success' => '<span class="badge bg-success">Success</span>',
        'error' => '<span class="badge bg-danger">Error</span>',
        'pending' => '<span class="badge bg-warning">Pending</span>',
        'processing' => '<span class="badge bg-info">Processing</span>',
        'cancelled' => '<span class="badge bg-secondary">Cancelled</span>'
    ];
    
    return $badges[$status] ?? '<span class="badge bg-light text-dark">' . ucfirst($status) . '</span>';
}

// System information helper functions
function getSystemInfo() {
    $info = [
        'php_version' => PHP_VERSION,
        'os' => PHP_OS,
        'server_software' => $_SERVER['SERVER_SOFTWARE'] ?? 'Unknown',
        'memory_limit' => ini_get('memory_limit'),
        'max_execution_time' => ini_get('max_execution_time'),
        'upload_max_filesize' => ini_get('upload_max_filesize'),
        'post_max_size' => ini_get('post_max_size'),
        'timezone' => date_default_timezone_get(),
        'disk_free_space' => disk_free_space('.'),
        'memory_usage' => memory_get_usage(true),
        'memory_peak_usage' => memory_get_peak_usage(true)
    ];
    
    return $info;
}

function formatBytes($size, $precision = 2) {
    $units = ['B', 'KB', 'MB', 'GB', 'TB'];
    
    for ($i = 0; $size > 1024 && $i < count($units) - 1; $i++) {
        $size /= 1024;
    }
    
    return round($size, $precision) . ' ' . $units[$i];
}

function getPhpExtensions() {
    $required = ['curl', 'pdo', 'pdo_mysql', 'json', 'mbstring'];
    $extensions = [];
    
    foreach ($required as $ext) {
        $extensions[$ext] = extension_loaded($ext);
    }
    
    return $extensions;
}
?>