<?php
require_once '../../config/database.php';
require_once '../config/admin.php';

AdminAuth::requireLogin();

$userId = $_GET['id'] ?? 0;

if (!$userId) {
    echo '<div class="alert alert-danger">User ID tidak valid</div>';
    exit;
}

$db = new Database();
$conn = $db->getConnection();

// Get user details
$stmt = $conn->prepare("
    SELECT u.*, 
           COUNT(v.id) as total_verifications,
           SUM(CASE WHEN v.status = 'success' THEN 1 ELSE 0 END) as success_verifications,
           SUM(CASE WHEN v.status = 'error' THEN 1 ELSE 0 END) as error_verifications,
           SUM(CASE WHEN v.status = 'pending' THEN 1 ELSE 0 END) as pending_verifications,
           MAX(v.created_at) as last_verification
    FROM users u 
    LEFT JOIN verifications v ON u.id = v.user_id 
    WHERE u.id = ?
    GROUP BY u.id
");
$stmt->execute([$userId]);
$user = $stmt->fetch();

if (!$user) {
    echo '<div class="alert alert-danger">User tidak ditemukan</div>';
    exit;
}

// Get user tokens
$stmt = $conn->prepare("SELECT * FROM user_tokens WHERE user_id = ? ORDER BY created_at DESC LIMIT 1");
$stmt->execute([$userId]);
$tokens = $stmt->fetch();

// Get recent verifications
$stmt = $conn->prepare("
    SELECT * FROM verifications 
    WHERE user_id = ? 
    ORDER BY created_at DESC 
    LIMIT 10
");
$stmt->execute([$userId]);
$verifications = $stmt->fetchAll();
?>

<div class="row">
    <div class="col-md-6">
        <h6>Informasi User</h6>
        <table class="table table-sm">
            <tr>
                <td><strong>Nama:</strong></td>
                <td><?php echo htmlspecialchars($user['first_name'] . ' ' . ($user['last_name'] ?? '')); ?></td>
            </tr>
            <tr>
                <td><strong>Username:</strong></td>
                <td>@<?php echo htmlspecialchars($user['username'] ?? 'N/A'); ?></td>
            </tr>
            <tr>
                <td><strong>Telegram ID:</strong></td>
                <td><code><?php echo $user['telegram_id']; ?></code></td>
            </tr>
            <tr>
                <td><strong>Bergabung:</strong></td>
                <td><?php echo formatDate($user['created_at']); ?></td>
            </tr>
            <tr>
                <td><strong>Terakhir Update:</strong></td>
                <td><?php echo formatDate($user['updated_at']); ?></td>
            </tr>
        </table>
    </div>
    
    <div class="col-md-6">
        <h6>Statistik Verifikasi</h6>
        <div class="row text-center">
            <div class="col-6">
                <div class="card bg-primary text-white">
                    <div class="card-body py-2">
                        <h4><?php echo $user['total_verifications']; ?></h4>
                        <small>Total</small>
                    </div>
                </div>
            </div>
            <div class="col-6">
                <div class="card bg-success text-white">
                    <div class="card-body py-2">
                        <h4><?php echo $user['success_verifications']; ?></h4>
                        <small>Sukses</small>
                    </div>
                </div>
            </div>
            <div class="col-6 mt-2">
                <div class="card bg-danger text-white">
                    <div class="card-body py-2">
                        <h4><?php echo $user['error_verifications']; ?></h4>
                        <small>Error</small>
                    </div>
                </div>
            </div>
            <div class="col-6 mt-2">
                <div class="card bg-warning text-white">
                    <div class="card-body py-2">
                        <h4><?php echo $user['pending_verifications']; ?></h4>
                        <small>Pending</small>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php if ($tokens): ?>
<div class="mt-4">
    <h6>Token API</h6>
    <div class="card">
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <strong>HCaptcha Token:</strong><br>
                    <small class="text-muted"><?php echo substr($tokens['hcaptcha_token'], 0, 20) . '...'; ?></small>
                </div>
                <div class="col-md-6">
                    <strong>Turnstile Token:</strong><br>
                    <small class="text-muted">
                        <?php echo $tokens['turnstile_token'] ? substr($tokens['turnstile_token'], 0, 20) . '...' : 'Tidak ada'; ?>
                    </small>
                </div>
            </div>
            <div class="mt-2">
                <small class="text-muted">Dibuat: <?php echo formatDate($tokens['created_at']); ?></small>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>

<?php if (!empty($verifications)): ?>
<div class="mt-4">
    <h6>Verifikasi Terbaru</h6>
    <div class="table-responsive">
        <table class="table table-sm">
            <thead>
                <tr>
                    <th>Verification ID</th>
                    <th>Status</th>
                    <th>Waktu</th>
                    <th>Pesan</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($verifications as $verification): ?>
                    <tr>
                        <td><code><?php echo htmlspecialchars($verification['verification_id']); ?></code></td>
                        <td><?php echo getStatusBadge($verification['status']); ?></td>
                        <td><small><?php echo formatDate($verification['created_at']); ?></small></td>
                        <td>
                            <small class="text-muted">
                                <?php echo htmlspecialchars(substr($verification['message'] ?? '', 0, 30)); ?>
                                <?php if (strlen($verification['message'] ?? '') > 30) echo '...'; ?>
                            </small>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>
<?php endif; ?>