<?php
session_start();
require_once '../../config/database.php';
require_once '../config/admin.php';

// Check admin authentication
if (!AdminAuth::isLoggedIn()) {
    http_response_code(401);
    echo json_encode(['error' => 'Unauthorized']);
    exit;
}

header('Content-Type: application/json');

// Get command information
$commands = [
    [
        'command' => '/start',
        'description' => 'Menu utama bot',
        'usage' => '/start',
        'admin_only' => false,
        'configurable_message' => 'start_message'
    ],
    [
        'command' => '/help',
        'description' => 'Bantuan dan panduan',
        'usage' => '/help',
        'admin_only' => false,
        'configurable_message' => 'help_message'
    ],
    [
        'command' => '/verify',
        'description' => 'Verifikasi single ID',
        'usage' => '/verify VERIFICATION_ID',
        'example' => '/verify vid_123456',
        'admin_only' => false,
        'configurable_message' => 'verify_success_message, verify_error_message'
    ],
    [
        'command' => '/batch',
        'description' => 'Verifikasi multiple IDs',
        'usage' => '/batch ID1,ID2,ID3',
        'example' => '/batch vid_123,vid_456,vid_789',
        'admin_only' => false,
        'configurable_message' => 'batch_success_message, batch_error_message'
    ],
    [
        'command' => '/status',
        'description' => 'Cek status sistem',
        'usage' => '/status [optional_token]',
        'example' => '/status atau /status check_token_123',
        'admin_only' => false,
        'configurable_message' => 'status_message'
    ],
    [
        'command' => '/myverifications',
        'description' => 'Lihat riwayat verifikasi',
        'usage' => '/myverifications',
        'admin_only' => false,
        'configurable_message' => null
    ],
    [
        'command' => '/admin',
        'description' => 'Panel admin',
        'usage' => '/admin [subcommand]',
        'example' => '/admin stats, /admin users, /admin tokens',
        'admin_only' => true,
        'configurable_message' => 'access_denied_message'
    ]
];

// Add system messages
$systemMessages = [
    [
        'type' => 'system',
        'name' => 'Maintenance Message',
        'description' => 'Pesan saat bot dalam maintenance',
        'configurable_message' => 'maintenance_message'
    ],
    [
        'type' => 'system',
        'name' => 'Access Denied Message',
        'description' => 'Pesan saat akses ditolak',
        'configurable_message' => 'access_denied_message'
    ],
    [
        'type' => 'system',
        'name' => 'Unknown Command Message',
        'description' => 'Pesan saat command tidak dikenal',
        'configurable_message' => 'unknown_command_message'
    ]
];

echo json_encode([
    'commands' => $commands,
    'system_messages' => $systemMessages,
    'total_commands' => count($commands),
    'admin_commands' => count(array_filter($commands, function($cmd) { return $cmd['admin_only']; })),
    'user_commands' => count(array_filter($commands, function($cmd) { return !$cmd['admin_only']; }))
]);
?>