<?php
require_once '../../config/database.php';
require_once '../config/admin.php';

AdminAuth::requireLogin();

$db = new Database();
$conn = $db->getConnection();

// Get filters from URL parameters
$status = $_GET['status'] ?? '';
$search = $_GET['search'] ?? '';
$dateFrom = $_GET['date_from'] ?? '';
$dateTo = $_GET['date_to'] ?? '';

// Build WHERE clause
$whereConditions = [];
$params = [];

if ($status) {
    $whereConditions[] = "v.status = ?";
    $params[] = $status;
}

if ($search) {
    $whereConditions[] = "(v.verification_id LIKE ? OR u.first_name LIKE ? OR u.username LIKE ?)";
    $params[] = "%$search%";
    $params[] = "%$search%";
    $params[] = "%$search%";
}

if ($dateFrom) {
    $whereConditions[] = "DATE(v.created_at) >= ?";
    $params[] = $dateFrom;
}

if ($dateTo) {
    $whereConditions[] = "DATE(v.created_at) <= ?";
    $params[] = $dateTo;
}

$whereClause = !empty($whereConditions) ? 'WHERE ' . implode(' AND ', $whereConditions) : '';

// Get verifications
$query = "
    SELECT v.*, u.first_name, u.last_name, u.username, u.telegram_id
    FROM verifications v 
    JOIN users u ON v.user_id = u.id 
    $whereClause
    ORDER BY v.created_at DESC
";

$stmt = $conn->prepare($query);
$stmt->execute($params);
$verifications = $stmt->fetchAll();

// Set headers for CSV download
header('Content-Type: text/csv');
header('Content-Disposition: attachment; filename="verifications_export_' . date('Y-m-d_H-i-s') . '.csv"');

// Create file pointer
$output = fopen('php://output', 'w');

// Add CSV headers
fputcsv($output, [
    'ID',
    'Verification ID',
    'User Name',
    'Username',
    'Telegram ID',
    'Status',
    'Message',
    'Check Token',
    'Created At',
    'Updated At'
]);

// Add data rows
foreach ($verifications as $verification) {
    fputcsv($output, [
        $verification['id'],
        $verification['verification_id'],
        trim($verification['first_name'] . ' ' . ($verification['last_name'] ?? '')),
        $verification['username'],
        $verification['telegram_id'],
        $verification['status'],
        $verification['message'],
        $verification['check_token'],
        formatDate($verification['created_at']),
        formatDate($verification['updated_at'])
    ]);
}

fclose($output);
?>