<?php
require_once '../../config/database.php';
require_once '../config/admin.php';

AdminAuth::requireLogin();

$db = new Database();
$conn = $db->getConnection();

// Get users with verification stats
$query = "
    SELECT u.*, 
           COUNT(v.id) as total_verifications,
           SUM(CASE WHEN v.status = 'success' THEN 1 ELSE 0 END) as success_verifications,
           MAX(v.created_at) as last_verification,
           ut.hcaptcha_token IS NOT NULL as has_token
    FROM users u 
    LEFT JOIN verifications v ON u.id = v.user_id 
    LEFT JOIN user_tokens ut ON u.id = ut.user_id
    GROUP BY u.id 
    ORDER BY u.created_at DESC
";

$stmt = $conn->query($query);
$users = $stmt->fetchAll();

// Set headers for CSV download
header('Content-Type: text/csv');
header('Content-Disposition: attachment; filename="users_export_' . date('Y-m-d_H-i-s') . '.csv"');

// Create file pointer
$output = fopen('php://output', 'w');

// Add CSV headers
fputcsv($output, [
    'ID',
    'Telegram ID',
    'First Name',
    'Last Name',
    'Username',
    'Total Verifications',
    'Success Verifications',
    'Has Token',
    'Last Verification',
    'Created At',
    'Updated At'
]);

// Add data rows
foreach ($users as $user) {
    fputcsv($output, [
        $user['id'],
        $user['telegram_id'],
        $user['first_name'],
        $user['last_name'],
        $user['username'],
        $user['total_verifications'],
        $user['success_verifications'],
        $user['has_token'] ? 'Yes' : 'No',
        $user['last_verification'] ? formatDate($user['last_verification']) : 'Never',
        formatDate($user['created_at']),
        formatDate($user['updated_at'])
    ]);
}

fclose($output);
?>