<?php
require_once '../config/admin.php';

AdminAuth::requireLogin();

$logFile = $_GET['log'] ?? '';
$allowedLogs = ['webhook.log', 'error.log', 'bot.log'];

if (!$logFile || !in_array($logFile, $allowedLogs)) {
    http_response_code(400);
    echo 'Invalid log file';
    exit;
}

$filePath = "../../logs/$logFile";

if (!file_exists($filePath)) {
    http_response_code(404);
    echo 'Log file not found';
    exit;
}

// Set headers for file download
header('Content-Type: text/plain');
header('Content-Disposition: attachment; filename="' . $logFile . '_' . date('Y-m-d_H-i-s') . '.log"');
header('Content-Length: ' . filesize($filePath));

// Output file content
readfile($filePath);
?>