# 🚀 Panel Admin Telegram Bot

Panel admin yang user-friendly untuk mengelola bot Telegram dengan interface modern dan fitur lengkap.

## ✨ Fitur Panel Admin

### 🏠 Dashboard
- **Statistik Real-time**: Total users, verifikasi sukses, pending, dan aktivitas hari ini
- **Grafik Aktivitas**: Chart verifikasi 7 hari terakhir
- **Quick Actions**: Akses cepat ke fitur utama
- **System Status**: Monitor status database, bot API, dan webhook
- **Aktivitas Terbaru**: Daftar verifikasi terbaru dengan detail

### 👥 Manajemen Users
- **Daftar Users**: Tampilan lengkap semua user dengan statistik
- **Pencarian & Filter**: Cari berdasarkan nama, username, atau Telegram ID
- **Detail User**: Modal popup dengan informasi lengkap user
- **Manajemen Token**: Lihat dan reset token API user
- **Export Data**: Export daftar user ke CSV/Excel

### ✅ Manajemen Verifikasi
- **Daftar Verifikasi**: Semua verifikasi dengan status dan detail
- **Filter Advanced**: Filter berdasarkan status, tanggal, dan user
- **Edit Status**: Update status verifikasi secara manual
- **Real-time Updates**: Auto-refresh untuk data terbaru
- **Export Reports**: Export laporan verifikasi

### ⚙️ Pengaturan Bot
- **Informasi Bot**: Detail bot dan status koneksi
- **Webhook Management**: Set, test, dan hapus webhook
- **System Information**: Info server, PHP, MySQL, dan resource
- **Quick Actions**: Clear logs, backup database, test connection
- **Configuration Files**: Tampilan konfigurasi database dan bot

### 📊 Fitur Tambahan
- **Responsive Design**: Tampilan optimal di desktop dan mobile
- **Dark/Light Theme**: Interface modern dengan gradient
- **Real-time Notifications**: Alert dan notifikasi untuk aksi
- **Security**: Session management dan CSRF protection
- **Logging**: Sistem log untuk debugging dan monitoring

## 🔐 Keamanan

### Autentikasi
- Login dengan username/password
- Session timeout otomatis
- Logout aman

### Proteksi File
- `.htaccess` untuk proteksi file sensitif
- Validasi input untuk mencegah injection
- CSRF protection untuk form

## 🎨 Interface Design

### Modern UI/UX
- **Bootstrap 5**: Framework CSS modern
- **Font Awesome**: Icon set lengkap
- **Chart.js**: Grafik interaktif
- **Gradient Design**: Warna modern dan menarik
- **Smooth Animations**: Transisi halus dan hover effects

### Responsive Layout
- **Mobile-First**: Optimized untuk semua device
- **Sidebar Navigation**: Menu navigasi yang mudah digunakan
- **Card-based Layout**: Organisasi konten yang rapi
- **Modal Dialogs**: Popup untuk detail dan form

## 📱 Fitur Mobile

- **Touch-Friendly**: Button dan interface yang mudah disentuh
- **Swipe Navigation**: Navigasi yang intuitif
- **Responsive Tables**: Tabel yang dapat di-scroll horizontal
- **Mobile Menu**: Hamburger menu untuk navigasi

## 🔧 Instalasi Panel Admin

### 1. Setup Kredensial Admin

Edit file `admin/config/admin.php`:

```php
define('ADMIN_USERNAME', 'your_admin_username');
define('ADMIN_PASSWORD', 'your_secure_password');
```

### 2. Akses Panel Admin

Buka browser dan akses:
```
http://yourdomain.com/admin/
```

### 3. Login

Gunakan kredensial yang telah Anda set di konfigurasi.

## 📋 Penggunaan Panel Admin

### Dashboard
- Lihat statistik real-time bot Anda
- Monitor aktivitas user dan verifikasi
- Akses quick actions untuk tugas umum

### Manajemen Users
- Lihat semua user yang terdaftar
- Cari user berdasarkan nama atau ID
- Lihat detail verifikasi per user
- Reset token API jika diperlukan

### Manajemen Verifikasi
- Monitor semua proses verifikasi
- Filter berdasarkan status atau tanggal
- Update status verifikasi manual
- Export laporan untuk analisis

### Pengaturan
- Cek status bot dan webhook
- Update konfigurasi webhook
- Monitor system resources
- Backup database

## 🛠️ Kustomisasi

### Mengubah Tema
Edit file `admin/includes/header.php` untuk mengubah warna dan style:

```css
.sidebar {
    background: linear-gradient(135deg, #your-color1 0%, #your-color2 100%);
}
```

### Menambah Menu
Edit file `admin/includes/header.php` untuk menambah item menu:

```html
<li class="nav-item">
    <a class="nav-link" href="your-page.php">
        <i class="fas fa-your-icon me-2"></i> Your Menu
    </a>
</li>
```

### Custom Dashboard Cards
Edit file `admin/index.php` untuk menambah statistik baru:

```php
// Get custom stats
$stmt = $conn->query("SELECT COUNT(*) as total FROM your_table");
$customStats = $stmt->fetch()['total'];
```

## 🔍 Troubleshooting

### Panel Admin Tidak Bisa Diakses
1. Pastikan file `.htaccess` sudah benar
2. Cek permission folder admin (755)
3. Pastikan web server mendukung PHP

### Login Gagal
1. Cek kredensial di `admin/config/admin.php`
2. Pastikan session PHP berfungsi
3. Clear browser cache dan cookies

### Data Tidak Muncul
1. Cek koneksi database
2. Pastikan tabel sudah dibuat dengan benar
3. Cek log error PHP

## 📈 Monitoring & Analytics

### Real-time Monitoring
- Dashboard auto-refresh setiap 30 detik
- Status indicators untuk system health
- Live notification untuk aktivitas baru

### Reports & Analytics
- Export data user dan verifikasi
- Grafik trend aktivitas
- Statistik success rate verifikasi

## 🔄 Update & Maintenance

### Update Panel Admin
1. Backup file konfigurasi
2. Replace file panel admin
3. Cek kompatibilitas database

### Maintenance Mode
Untuk maintenance, rename file `admin/index.php` menjadi `admin/index.php.bak` dan buat file maintenance.html.

## 📞 Support

Jika mengalami masalah dengan panel admin:

1. Cek log error di browser console
2. Cek log PHP error
3. Pastikan semua dependency terpenuhi
4. Cek permission file dan folder

Panel admin ini dirancang untuk memberikan pengalaman manajemen bot yang mudah dan efisien dengan interface yang modern dan user-friendly.