# Telegram Bot Verification - PHP Native + MySQL

Bot Telegram sederhana untuk sistem verifikasi menggunakan PHP Native dan MySQL, berdasarkan API specification yang disediakan.

## 🎨 Panel Admin Modern

Bot ini dilengkapi dengan **Panel Admin yang sangat user-friendly** dengan fitur:

### ✨ Fitur Panel Admin:
- **🏠 Dashboard Interaktif**: Statistik real-time, grafik aktivitas, quick actions
- **👥 Manajemen Users**: Daftar users, pencarian, detail user, manajemen token
- **✅ Manajemen Verifikasi**: Monitor verifikasi, filter advanced, edit status
- **📊 Batch Verifications**: Kelola verifikasi batch dengan progress tracking
- **⚙️ Pengaturan Bot**: Webhook management, system info, bot configuration
- **📋 System Logs**: Monitor logs real-time, download, clear logs
- **🔐 Keamanan**: Login system, session management, file protection

### 🎨 Design Modern:
- **Responsive Design** untuk desktop dan mobile
- **Bootstrap 5** dengan gradient design yang menarik
- **Real-time Updates** dengan auto-refresh
- **Interactive Charts** untuk visualisasi data
- **Modern UI/UX** dengan smooth animations

### 🚀 Akses Panel Admin:
```
http://yourdomain.com/admin/
```

**Default Login:**
- Username: `admin`
- Password: `admin123` (Ganti di `admin/config/admin.php`)

---

- ✅ Verifikasi single ID
- ✅ Verifikasi batch (multiple IDs)
- ✅ Manajemen token API (HCaptcha & Turnstile)
- ✅ Cek status verifikasi
- ✅ Riwayat verifikasi user
- ✅ Interface bot yang user-friendly
- ✅ Database MySQL untuk penyimpanan data

## 📋 Persyaratan

- PHP 7.4 atau lebih tinggi
- MySQL 5.7 atau lebih tinggi
- cURL extension untuk PHP
- PDO MySQL extension
- Web server (Apache/Nginx)

## 🛠️ Instalasi

### 1. Clone/Download Project

```bash
git clone [repository-url]
cd telegram-bot-verification
```

### 2. Konfigurasi Database

Edit file `config/database.php`:

```php
define('DB_HOST', 'localhost');
define('DB_NAME', 'telegram_bot');
define('DB_USER', 'your_username');
define('DB_PASS', 'your_password');
```

### 3. Konfigurasi Bot Telegram

1. Buat bot baru di [@BotFather](https://t.me/BotFather)
2. Dapatkan Bot Token
3. Edit file `config/telegram.php`:

```php
define('BOT_TOKEN', 'YOUR_BOT_TOKEN_HERE');
```

### 4. Setup Database

Jalankan setup database:

```bash
# Via CLI
php setup.php database

# Atau via web browser
# Akses: http://yourdomain.com/setup.php
```

### 5. Set Webhook

```bash
# Via CLI
php setup.php webhook https://yourdomain.com/webhook.php

# Atau via web interface
```

### 6. Test Bot

```bash
php setup.php test
```

## 📁 Struktur Project

```
telegram-bot-verification/
├── config/
│   ├── database.php          # Konfigurasi database
│   └── telegram.php          # Konfigurasi bot Telegram
├── models/
│   ├── User.php              # Model untuk user
│   └── Verification.php      # Model untuk verifikasi
├── services/
│   └── VerificationService.php # Service untuk API calls
├── handlers/
│   └── CommandHandler.php    # Handler untuk command bot
├── database/
│   └── schema.sql            # Schema database
├── logs/                     # Folder untuk log files
├── webhook.php               # Endpoint webhook
├── setup.php                 # Script setup
└── README.md
```

## 🤖 Perintah Bot

### Perintah Dasar

- `/start` - Memulai bot dan menampilkan menu utama
- `/help` - Menampilkan bantuan dan cara penggunaan

### Manajemen Token

- `/settoken TOKEN` - Set HCaptcha token
- `/settoken HCAPTCHA_TOKEN TURNSTILE_TOKEN` - Set kedua token

### Verifikasi

- `/verify VERIFICATION_ID` - Verifikasi single ID
- `/batch ID1,ID2,ID3` - Verifikasi multiple IDs (maksimal 10)

### Status & Riwayat

- `/status` - Cek status sistem
- `/status CHECK_TOKEN` - Cek status verifikasi tertentu
- `/myverifications` - Lihat riwayat verifikasi

## 💡 Contoh Penggunaan

```
# Set token API
/settoken abc123def456ghi789

# Verifikasi single
/verify vid_123456789

# Verifikasi batch
/batch vid_123,vid_456,vid_789

# Cek status
/status check_token_123
```

## 🔧 Konfigurasi API

Edit file `services/VerificationService.php` untuk mengubah base URL API:

```php
public function __construct($apiBaseUrl = 'https://your-api-domain.com') {
    // ...
}
```

## 📊 Database Schema

Bot menggunakan 4 tabel utama:

- `users` - Data user Telegram
- `verifications` - Data verifikasi individual
- `batch_verifications` - Data batch verifikasi
- `user_tokens` - Token API user

## 🔒 Keamanan

- Token API disimpan terenkripsi di database
- Validasi input untuk mencegah injection
- Rate limiting untuk mencegah spam
- CSRF protection untuk API calls

## 🐛 Debugging

### Enable Debug Mode

Tambahkan di `webhook.php`:

```php
define('DEBUG', true);
```

Log akan tersimpan di `logs/webhook.log`.

### Cek Webhook Status

```bash
php setup.php webhook-info
```

### Test Manual

```bash
# Test bot connection
php setup.php test

# Test database connection
php -r "require 'config/database.php'; new Database();"
```

## 📝 Troubleshooting

### Bot tidak merespon

1. Cek token bot di `config/telegram.php`
2. Pastikan webhook sudah diset dengan benar
3. Cek log error di `logs/webhook.log`

### Database error

1. Pastikan kredensial database benar
2. Pastikan database sudah dibuat
3. Jalankan ulang setup database

### API error

1. Cek base URL API di `VerificationService.php`
2. Pastikan token API valid
3. Cek koneksi internet server

## 🔄 Update & Maintenance

### Update Bot

1. Backup database
2. Update file code
3. Restart web server jika diperlukan

### Monitoring

- Monitor log files secara berkala
- Cek status webhook: `php setup.php webhook-info`
- Monitor penggunaan database

## 📞 Support

Jika mengalami masalah:

1. Cek log error di `logs/`
2. Pastikan semua konfigurasi sudah benar
3. Test koneksi database dan bot secara terpisah

## 📄 License

MIT License - Silakan digunakan dan dimodifikasi sesuai kebutuhan.